/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManagerImpl
implements ClaimedChunkManager {
    public static final class_5218 DATA_DIR = new class_5218("ftbchunks");
    private static final Long2ObjectMap<UUID> EMPTY_CHUNKS = Long2ObjectMaps.emptyMap();
    protected static final String BYPASS_FTB_CHUNKS_PROTECTION = "BypassFTBChunksProtection";
    private static ClaimedChunkManagerImpl instance;
    private final TeamManager teamManager;
    private final Map<UUID, ChunkTeamDataImpl> teamData;
    private final Map<ChunkDimPos, ClaimedChunkImpl> claimedChunks;
    private final Path dataDirectory;
    private Map<class_5321<class_1937>, Long2ObjectMap<UUID>> forceLoadedChunkCache;

    public ClaimedChunkManagerImpl(TeamManager teamManager) {
        this.teamManager = teamManager;
        this.teamData = new HashMap<UUID, ChunkTeamDataImpl>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunkImpl>();
        this.dataDirectory = this.getMinecraftServer().method_27050(DATA_DIR);
        Path localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(localDirectory, new LinkOption[0])) {
                Files.createDirectories(localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ClaimedChunkManagerImpl getInstance() {
        return instance;
    }

    public static void init(TeamManager teamManager) {
        instance = new ClaimedChunkManagerImpl(teamManager);
    }

    public static void shutdown() {
        instance = null;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public void initForceLoadedChunks(class_3218 level) {
        Long2ObjectMap<UUID> map = this.getForceLoadedChunks((class_5321<class_1937>)level.method_27983());
        if (map.isEmpty() || level.method_14178() == null) {
            return;
        }
        map.forEach((pos, id) -> {
            class_1923 chunkPos = new class_1923(pos.longValue());
            FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", id, chunkPos.field_9181, chunkPos.field_9180, true);
        });
        level.method_14178().method_17298(false);
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(map.size(), level.method_27983().method_29177()));
    }

    private ChunkTeamDataImpl loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(String.valueOf(team.getId()) + ".snbt");
        ChunkTeamDataImpl data = new ChunkTeamDataImpl(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((class_2487)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.getServer();
    }

    @Override
    public ChunkTeamDataImpl getOrCreateData(@NotNull Team team) {
        ChunkTeamDataImpl data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    @Override
    public ChunkTeamDataImpl getPersonalData(UUID id) {
        return this.getTeamManager().getPlayerTeamForPlayerID(id).map(this::getOrCreateData).orElse(null);
    }

    @Override
    public ChunkTeamDataImpl getOrCreateData(class_3222 player) {
        return this.getTeamManager().getTeamForPlayer(player).map(this::getOrCreateData).orElse(null);
    }

    public void deleteTeam(Team toDelete) {
        ChunkTeamDataImpl data = this.teamData.get(toDelete.getId());
        if (data != null && toDelete.getMembers().isEmpty()) {
            FTBChunks.LOGGER.debug("dropping references to empty team " + String.valueOf(toDelete.getId()));
            this.teamData.remove(toDelete.getId());
            try {
                Files.deleteIfExists(data.getFile());
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error(String.format("can't delete file %s: %s", data.getFile(), e.getMessage()));
            }
        }
    }

    @Override
    @Nullable
    public ClaimedChunkImpl getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunkImpl> getAllClaimedChunks() {
        return Collections.unmodifiableCollection(this.claimedChunks.values());
    }

    @Override
    public Map<UUID, Collection<ClaimedChunk>> getClaimedChunksByTeam(Predicate<ClaimedChunk> predicate) {
        return Collections.unmodifiableMap(this.getAllClaimedChunks().stream().filter(predicate).collect(Collectors.groupingBy(cc -> cc.getTeamData().getTeam().getId())));
    }

    @Override
    public boolean getBypassProtection(UUID player) {
        return this.teamManager.getPlayerTeamForPlayerID(player).map(team -> team.getExtraData().method_10577(BYPASS_FTB_CHUNKS_PROTECTION)).orElse(false);
    }

    @Override
    public void setBypassProtection(UUID player, boolean bypass) {
        this.teamManager.getPlayerTeamForPlayerID(player).ifPresent(team -> {
            team.getExtraData().method_10556(BYPASS_FTB_CHUNKS_PROTECTION, bypass);
            team.markDirty();
        });
    }

    @Override
    public boolean shouldPreventInteraction(@Nullable class_1297 actor, class_1268 hand, class_2338 pos, Protection protection, @Nullable class_1297 targetEntity) {
        class_3222 player;
        block10: {
            block9: {
                if (!(actor instanceof class_3222)) break block9;
                player = (class_3222)actor;
                if (!((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue() && player.method_37908() != null) break block10;
            }
            return false;
        }
        boolean isFake = PlayerHooks.isFake((class_1657)player);
        if (isFake && ((ProtectionPolicy)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionPolicy)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).shouldPreventInteraction();
        }
        ClaimedChunkImpl chunk = this.getChunk(new ChunkDimPos(player.method_37908(), pos));
        if (chunk != null) {
            boolean prevented;
            ProtectionPolicy policy = protection.getProtectionPolicy(player, pos, hand, chunk, targetEntity);
            boolean bl = policy.isOverride() ? policy.shouldPreventInteraction() : (prevented = !player.method_7325() && (isFake || !this.getBypassProtection(player.method_5667())));
            if (prevented && isFake) {
                chunk.getTeamData().logPreventedAccess(player, System.currentTimeMillis());
            }
            return prevented;
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionPolicy override = protection.getProtectionPolicy(player, pos, hand, null, targetEntity);
            if (override.isOverride()) {
                return override.shouldPreventInteraction();
            }
            if (!isFake && (this.getBypassProtection(player.method_5667()) || player.method_7325())) {
                return false;
            }
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbchunks.need_to_claim_chunk"), true);
            return true;
        }
        return false;
    }

    public void clearForceLoadedCache() {
        this.forceLoadedChunkCache = null;
    }

    @Override
    public Map<class_5321<class_1937>, Long2ObjectMap<UUID>> getForceLoadedChunks() {
        if (this.forceLoadedChunkCache == null) {
            this.forceLoadedChunkCache = new HashMap<class_5321<class_1937>, Long2ObjectMap<UUID>>();
            for (ClaimedChunkImpl chunk : this.getAllClaimedChunks()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                Long2ObjectMap pos2idMap = this.forceLoadedChunkCache.computeIfAbsent((class_5321<class_1937>)chunk.getPos().dimension(), k -> new Long2ObjectOpenHashMap());
                pos2idMap.put(class_1923.method_8331((int)chunk.getPos().x(), (int)chunk.getPos().z()), (Object)chunk.getTeamData().getTeamId());
            }
            this.forceLoadedChunkCache = this.forceLoadedChunkCache.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunkCache;
        }
        return Collections.unmodifiableMap(this.forceLoadedChunkCache);
    }

    @Override
    @NotNull
    public Long2ObjectMap<UUID> getForceLoadedChunks(class_5321<class_1937> dimension) {
        return this.getForceLoadedChunks().getOrDefault(dimension, EMPTY_CHUNKS);
    }

    @Override
    public boolean isChunkForceLoaded(ChunkDimPos chunkDimPos) {
        return this.getForceLoadedChunks((class_5321<class_1937>)chunkDimPos.dimension()).containsKey(chunkDimPos.getChunkPos().method_8324());
    }

    public void registerClaim(ChunkDimPos pos, ClaimedChunk chunk) {
        if (chunk instanceof ClaimedChunkImpl) {
            ClaimedChunkImpl impl = (ClaimedChunkImpl)chunk;
            this.claimedChunks.put(pos, impl);
        }
    }

    public void unregisterClaim(ChunkDimPos pos) {
        this.claimedChunks.remove(pos);
    }
}

